# SPDX-FileCopyrightText: 2017 Scott Shawcroft, written for Adafruit Industries
# SPDX-FileCopyrightText: Copyright (c) 2023 Tyler Crumpton
#
# SPDX-License-Identifier: MIT
"""
`gc9d01`
================================================================================

displayio driver for GC9D01 TFT LCD displays


* Author(s): Tyler Crumpton

Implementation Notes
--------------------

**Software and Dependencies:**

* Adafruit CircuitPython firmware for the supported boards:
  https://circuitpython.org/downloads
"""

# imports

__version__ = "0.0.0+auto.0"
__repo__ = "https://github.com/tylercrumpton/CircuitPython_GC9D01.git"

import busdisplay

_INIT_SEQUENCE = bytearray(
b"\xFE\x00"
b"\xEF\x00"
b"\x80\x01\xFF"
b"\x81\x01\xFF"
b"\x82\x01\xFF"
b"\x83\x01\xFF"
b"\x84\x01\xFF"
b"\x85\x01\xFF"
b"\x86\x01\xFF"
b"\x87\x01\xFF"
b"\x88\x01\xFF"
b"\x89\x01\xFF"
b"\x8A\x01\xFF"
b"\x8B\x01\xFF"
b"\x8C\x01\xFF"
b"\x8D\x01\xFF"
b"\x8E\x01\xFF"
b"\x8F\x01\xFF"
b"\x3A\x01\x05"
b"\xEC\x01\x01"
b"\x74\x07\x02\x0E\x00\x00\x00\x00\x00"
b"\x98\x01\x3E"
b"\x99\x01\x3E"
b"\xB5\x02\x0D\x0D"
b"\x60\x04\x38\x0F\x79\x67"
b"\x61\x04\x38\x11\x79\x67"
b"\x64\x06\x38\x17\x71\x5F\x79\x67"
b"\x65\x06\x38\x13\x71\x5B\x79\x67"
b"\x6A\x02\x00\x00"
b"\x6C\x07\x22\x02\x22\x02\x22\x22\x50"
b"\x6E\x20\x03\x03\x01\x01\x00\x00\x0F\x0F\x0D\x0D\x0B\x0B\x09\x09\x00\x00\x00\x00\x0A\x0A\x0C\x0C\x0E\x0E\x10\x10\x00\x00\x02\x02\x04\x04"
b"\xBF\x01\x01"
b"\xF9\x01\x40"
b"\x9B\x01\x3B"
b"\x93\x03\x33\x7F\x00"
b"\x7E\x01\x30"
b"\x70\x06\x0D\x02\x08\x0D\x02\x08"
b"\x71\x03\x0D\x02\x08"
b"\x91\x02\x0E\x09"
b"\xC3\x01\x19"
b"\xC4\x01\x19"
b"\xC9\x01\x3C"
b"\xF0\x06\x53\x15\x0A\x04\x00\x3E"
b"\xF2\x06\x53\x15\x0A\x04\x00\x3A"
b"\xF1\x06\x56\xA8\x7F\x33\x34\x5F"
b"\xF3\x06\x52\xA4\x7F\x33\x34\xDF"
b"\x36\x01\x00"
b"\x11\x80\xC8"
b"\x29\x00\x14"
b"\x2C\x00"
)


# pylint: disable=too-few-public-methods
class GC9D01(busdisplay.BusDisplay):
    """GC9D01 displayio driver"""

    def __init__(self, bus, **kwargs):
        init_sequence = _INIT_SEQUENCE
        super().__init__(bus, init_sequence, **kwargs)
