# SPDX-FileCopyrightText: 2017 Scott Shawcroft, written for Adafruit Industries
# SPDX-FileCopyrightText: Copyright (c) 2023 Tyler Crumpton
#
# SPDX-License-Identifier: Unlicense

import board
import busio
import digitalio
import displayio
import fourwire
from gc9d01 import GC9D01
from jpegio import JpegDecoder
import time

displayio.release_displays()

filename = "/chicken-160px.jpg"

tft_clk  = board.D6
tft_mosi = board.D7

tftA_rst = board.D0
tftA_dc  = board.D1
tftA_cs  = board.D2

tftB_rst = board.D3
tftB_dc  = board.D4
tftB_cs  = board.D5

tftC_rst = board.D8
tftC_dc  = board.D9
tftC_cs  = board.D10

spi = busio.SPI (clock=tft_clk, MOSI=tft_mosi)
while not spi.try_lock():
    pass
spi.configure(baudrate=1000000)
spi.unlock()

display_busA = fourwire.FourWire(spi, command=tftA_dc, chip_select=tftA_cs, reset=tftA_rst)
display_busB = fourwire.FourWire(spi, command=tftB_dc, chip_select=tftB_cs, reset=tftB_rst)
display_busC = fourwire.FourWire(spi, command=tftC_dc, chip_select=tftC_cs, reset=tftC_rst)

displayA = GC9D01 (display_busA, width=160, height=160, rotation=0, backlight_pin=None)
displayB = GC9D01 (display_busB, width=160, height=160, rotation=0, backlight_pin=None)
displayC = GC9D01 (display_busC, width=160, height=160, rotation=180, backlight_pin=None)

decoder = JpegDecoder()

width, height = decoder.open(filename)
bitmap = displayio.Bitmap(width, height, 65536)
decoder.decode(bitmap)

width, height = decoder.open("red-160px.jpg")
bitmap_red = displayio.Bitmap(width, height, 65536)
decoder.decode(bitmap_red)

width, height = decoder.open("yellow-160px.jpg")
bitmap_green = displayio.Bitmap(width, height, 65536)
decoder.decode(bitmap_green)

width, height = decoder.open("green-160px.jpg")
bitmap_blue = displayio.Bitmap(width, height, 65536)
decoder.decode(bitmap_blue)

grid0 = displayio.TileGrid (bitmap, pixel_shader=displayio.ColorConverter(input_colorspace=displayio.Colorspace.RGB565_SWAPPED))

gridA = displayio.TileGrid (bitmap_red, pixel_shader=displayio.ColorConverter(input_colorspace=displayio.Colorspace.RGB565_SWAPPED))
gridB = displayio.TileGrid (bitmap_green, pixel_shader=displayio.ColorConverter(input_colorspace=displayio.Colorspace.RGB565_SWAPPED))
gridC = displayio.TileGrid (bitmap_blue, pixel_shader=displayio.ColorConverter(input_colorspace=displayio.Colorspace.RGB565_SWAPPED))

group0 = displayio.Group()
group0.append(grid0)

groupA = displayio.Group()
groupA.append(gridA)

groupB = displayio.Group()
groupB.append(gridB)

groupC = displayio.Group()
groupC.append(gridC)

displayA.root_group = groupA
displayA.refresh()
displayB.root_group = groupB
displayB.refresh()
displayC.root_group = groupC
displayC.refresh()

while True:
    time.sleep(1)
    displayC.root_group = groupC
    displayA.root_group = group0
    time.sleep(1)
    displayA.root_group = groupA
    displayB.root_group = group0
    time.sleep(1)
    displayB.root_group = groupB
    displayC.root_group = group0
